<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Branch extends Model 
{

    protected $table = 'branches';
    public $timestamps = true;

    public function facilities()
    {
        return $this->hasMany('App\Models\Facilitie', 'facilitie_id');
    }

    public function offers()
    {
        return $this->hasMany('App\Models\Offer', 'offer_id');
    }

    public function clinic()
    {
        return $this->belongsTo('App\Models\Clinic', 'clinic_id');
    }

}